import { FormFieldType } from '@yandex-infracloud-ui/libs';

import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';
import { ignoreMaintenanceField, reasonField, ticketKeyField } from './commonFields';
import { EnumField } from '../../../rich_shared/form_fields';

interface IForceStatusHostParams extends IHostActionParams {
   /**
    * Status that will be forced for the specified host
    */
   status: 'ready' | 'manual' | 'dead';

   /**
    * Attach ticket to host's manual status.
    */
   ticket_key: string;
}

export class ForceStatusHostAction extends HostActionMeta<IForceStatusHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.ForceStatus,
         fields: [
            {
               label: 'Status',
               name: 'status',
               options: [
                  { value: 'ready', title: 'Ready' },
                  { value: 'manual', title: 'Manual' },
                  { value: 'dead', title: 'Dead' },
               ],
               type: FormFieldType.Custom,
               component: EnumField,
            },
            {
               ...ticketKeyField,
               isHidden: p => p.status === 'ready',
            },

            reasonField,

            // Options
            ignoreMaintenanceField,
         ],
         initialValue: {
            ignore_maintenance: false,
            reason: '',
            status: 'manual',
            ticket_key: '',
         },
         labels: {
            cancel: 'I changed my mind',
            run: 'Cancel and change the status',
         },
         name: 'Change status (deprecated)',
         titles: ['Cancel the operation and status change', 'Cancel the operation and status change'],
      });
   }
}
