import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IHost } from '../../../models';
import { userSwitcherDecorator } from '../../../stories';

import { HostActionModal } from '../components/HostActionModal';
import { FqdnDeinvalidationHost } from './FqdnDeinvalidationHost';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual' } as any];

const meta = new FqdnDeinvalidationHost();

storiesOf('actions|host_actions/actions', module)
   .addDecorator(userSwitcherDecorator)
   .add('FqdnDeinvalidationHost', () => (
      <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />
   ));
