import { FormFieldType } from '@yandex-infracloud-ui/libs';

import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';
import { disableAdminRequestsField, ignoreCmsField, reasonField } from './commonFields';

interface FqdnDeinvalidationHostParams extends IHostActionParams {
   /**
    * Clear DNS records, remove host from LUI
    */
   clear_old_fqdn_records: boolean;

   /**
    * Don't issue any admin requests if something is broken - just fail the task
    */
   disable_admin_requests: boolean;

   /**
    * Don't acquire permission from CMS
    */
   ignore_cms: boolean;

   /**
    * An optional reason string
    */
   reason: string;

   /**
    * Release the host (erase disks, power-off, set state as free)
    */
   release: boolean;
}

export class FqdnDeinvalidationHost extends HostActionMeta<FqdnDeinvalidationHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.FqdnDeinvalidation,
         fields: [
            {
               checkboxLabel: 'Clear old FQDN records',
               getHelp: () => 'Clear DNS records, remove host from LUI',
               name: 'clear_old_fqdn_records',
               type: FormFieldType.Boolean,
            },
            {
               checkboxLabel: 'Release',
               getHelp: () => 'Release the host (erase disks, power-off, set state as free)',
               name: 'release',
               type: FormFieldType.Boolean,
            },

            reasonField,

            // Options
            disableAdminRequestsField,
            ignoreCmsField,
         ],
         initialValue: {
            clear_old_fqdn_records: false,
            disable_admin_requests: false,
            ignore_cms: false,
            release: false,
            ignore_maintenance: false,
            reason: '',
         },
         name: 'FQDN deinvalidation',
         titles: ['FQDN deinvalidation', 'FQDN deinvalidation'],
      });
   }
}
