import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';
import {
   checkField,
   disableAdminRequestsField,
   ignoreMaintenanceField,
   reasonField,
   withAutoHealingField,
} from './commonFields';

interface IPowerOnHostParams extends IHostActionParams {
   /**
    * Check host after task completion and consider it as failed if host is not healthy
    */
   check: boolean; // true by default

   /**
    * Don't issue any admin requests if something is broken - just fail the task
    */
   disable_admin_requests: boolean; // false by default

   /**
    * Try to automatically repair the host if task will fail
    */
   with_auto_healing: boolean; // false by default (for API), true for UI
}

export class PowerOnHostAction extends HostActionMeta<IPowerOnHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.PowerOn,
         fields: [
            reasonField,

            // Options
            checkField,
            withAutoHealingField,
            disableAdminRequestsField,
            ignoreMaintenanceField,
         ],
         initialValue: {
            check: true,
            disable_admin_requests: false,
            ignore_maintenance: false,
            reason: '',
            with_auto_healing: true,
         },
         name: 'Power on',
         titles: ['Power on the host', 'Power on the hosts'],
      });
   }
}
