import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IHost } from '../../../models';
import { reduxStoryDecorator, userSwitcherDecorator } from '../../../stories';

import { HostActionModal } from '../components/HostActionModal';
import { PrepareHostAction } from './PrepareHostAction';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual' } as any];

const meta = new PrepareHostAction();

storiesOf('actions|host_actions/actions', module)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('PrepareHostAction', () => (
      <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />
   ));
