import * as React from 'react';
import { HostActionModal } from '../components/HostActionModal';
import { IHost } from '../../../models';
import { RebootHostAction } from './RebootHostAction';
import { action } from '@storybook/addon-actions';
import { loadProjects } from 'state/projects';
import { useDispatch } from 'react-redux';
import { useEffect } from 'react';
import { userSwitcherDecorator, reduxStoryDecorator } from '../../../stories';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual', project: 'test' } as any];

const meta = new RebootHostAction();

function Story() {
   const dispatch = useDispatch();

   useEffect(() => {
      dispatch(loadProjects(true));
   }, [dispatch]);

   return <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />;
}

export const Regular = () => <Story />;

// eslint-disable-next-line import/no-anonymous-default-export
export default {
   decorators: [reduxStoryDecorator, userSwitcherDecorator],
   title: 'actions|host_actions/actions/RebootHostAction',
};
