import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IHost } from '../../../models';
import { reduxStoryDecorator, userSwitcherDecorator } from '../../../stories';

import { HostActionModal } from '../components/HostActionModal';
import { RedeployHostAction } from './RedeployHostAction';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual' } as any];

const meta = new RedeployHostAction();

storiesOf('actions|host_actions/actions', module)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('RedeployHostAction', () => (
      <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />
   ));
