import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IHost } from '../../../models';
import { userSwitcherDecorator } from '../../../stories';

import { HostActionModal } from '../components/HostActionModal';
import { ReleaseHostAction } from './ReleaseHostAction';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual' } as any];

const meta = new ReleaseHostAction();

storiesOf('actions|host_actions/actions', module)
   .addDecorator(userSwitcherDecorator)
   .add('ReleaseHostAction', () => (
      <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />
   ));
