import { HostAction, HostActionMeta } from '../models';
import { IHostActionParams } from '../../../models';
import { reasonField, eraseDiskField, ignoreCmsField, disableAdminRequestsField } from './commonFields';

interface IReleaseHostParams extends IHostActionParams {
   /**
    * Erase disks while releasing host
    */
   erase_disks: boolean; // true by default

   /**
    * Don't acquire permission from CMS
    */
   ignore_cms: boolean;

   /**
    * Don't issue any admin requests if something is broken - just fail the task
    */
   disable_admin_requests: boolean; // false by default
}

export class ReleaseHostAction extends HostActionMeta<IReleaseHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.Release,
         fields: [reasonField, eraseDiskField, ignoreCmsField, disableAdminRequestsField],
         initialValue: {
            ignore_maintenance: false,
            reason: '',
            erase_disks: true,
            ignore_cms: false,
            disable_admin_requests: false,
         },
         name: 'Release',
         titles: ['Release the host', 'Release the hosts'],
      });
   }
}
