import { FormFieldType } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';

import { IHost, IRemoveHostParams } from '../../../models';
import { hostApi } from '../../../services';
import { HostAction, HostActionMeta } from '../models';
import { disableAdminRequestsField, ignoreCmsField, ignoreMaintenanceField, reasonField } from './commonFields';

// TODO придумать как файрить сайдэффекты, например, смена страницы, обновление списка хостов
export class RemoveHostAction extends HostActionMeta<IRemoveHostParams> {
   public readonly important: boolean = false;

   constructor() {
      super({
         action: HostAction.Remove,
         fields: [
            {
               checkboxLabel: 'Delete from LUI',
               name: 'lui',
               type: FormFieldType.Boolean,
            },

            reasonField,

            // Options
            {
               checkboxLabel: 'Do not create the task',
               name: 'instant',
               type: FormFieldType.Boolean,
            },
            {
               ...disableAdminRequestsField,
               isHidden: p => p.instant || disableAdminRequestsField.isHidden!(p),
            },
            {
               ...ignoreCmsField,
               isHidden: p => p.instant || ignoreCmsField.isHidden!(p),
            },
            ignoreMaintenanceField,
         ],
         initialValue: {
            disable_admin_requests: false,
            ignore_cms: false,
            ignore_maintenance: false,
            instant: false,
            lui: false,
            reason: '',
         },
         name: 'Remove',
         titles: ['Remove the host from the project', 'Remove hosts from the project'],
      });
   }

   public do(host: IHost, params: IRemoveHostParams, context: IHost[]): Observable<any> {
      return hostApi.remove(host.uuid, this.clean(params, context));
   }
}
