import { FormFieldType } from '@yandex-infracloud-ui/libs';

import { IHostActionParams } from '../../../models';
import { HostAction, HostActionMeta } from '../models';
import {
   checkField,
   disableAdminRequestsField,
   ignoreMaintenanceField,
   reasonField,
   withAutoHealingField,
} from './commonFields';

import { EnumField } from '../../../rich_shared/form_fields';

interface ISetAssignedHostParams extends IHostActionParams {
   /**
    * Check host after task completion and consider it as failed if host is not healthy
    */
   check: boolean;

   /**
    * Don't issue any admin requests if something is broken - just fail the task
    */
   disable_admin_requests: boolean;

   /**
    * Power on the host
    */
   power_on: boolean;

   /**
    * Status that will be assigned for the specified host
    */
   status: 'ready' | 'dead';

   /**
    * Try to automatically repair the host if task will fail
    */
   with_auto_healing: boolean;
}

export class SetAssignedHostAction extends HostActionMeta<ISetAssignedHostParams> {
   public readonly important: boolean = true;

   constructor() {
      super({
         action: HostAction.SetAssigned,
         fields: [
            {
               label: 'Status',
               name: 'status',
               options: [
                  { value: 'ready', title: 'Ready' },
                  { value: 'dead', title: 'Dead' },
               ],
               type: FormFieldType.Custom,
               component: EnumField,
            },
            {
               checkboxLabel: 'Power on the host',
               name: 'power_on',
               type: FormFieldType.Boolean,
            },
            reasonField,

            // Options
            checkField,
            withAutoHealingField,
            disableAdminRequestsField,
            ignoreMaintenanceField,
         ],
         initialValue: {
            check: true,
            disable_admin_requests: false,
            ignore_maintenance: false,
            power_on: false,
            reason: '',
            status: 'ready',
            with_auto_healing: true,
         },
         name: 'Set assigned',
         titles: ['Set the host assigned', 'Set the hosts assigned'],
      });
   }
}
