import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IHost } from '../../../models';
import { routerDecorator, userSwitcherDecorator, reduxStoryDecorator } from '../../../stories';

import { HostActionModal } from '../components/HostActionModal';
import { SwitchProjectHostAction } from './SwitchProjectHostAction';

const context: IHost[] = [{ name: 'sandbox.search.yandex.net', status: 'manual' } as any];

const meta = new SwitchProjectHostAction();

storiesOf('actions|host_actions/actions', module)
   .addDecorator(userSwitcherDecorator)
   .addDecorator(routerDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('SwitchProjectHostAction', () => (
      <HostActionModal context={context} meta={meta} onRun={action('onOk')} onCancel={action('onCancel')} />
   ));
