import { DISMISS_REASON, FormLayout, IFormField, IModalProps, ModalLayout } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { IHostActionParams } from '../../../models';

import { ignoreMaintenanceField, reasonField } from '../actions/commonFields';

interface IProps {
   title: string;
}

const fields: IFormField<IHostActionParams>[] = [reasonField, ignoreMaintenanceField];

export const BaseHostParamsModal = React.memo(({ title, ok, cancel }: IProps & IModalProps<IHostActionParams>) => {
   // hooks
   const [value, setValue] = useState<IHostActionParams>({
      ignore_maintenance: false,
      reason: '',
   });

   // handlers
   const onOk = () => ok(value);
   const onCancel = () => cancel(DISMISS_REASON);
   const updateParams = (e: SyntheticEvent | null, v: IHostActionParams) => setValue(v);

   // render
   return (
      <ModalLayout title={title} onOk={onOk} onDismiss={onCancel}>
         <FormLayout onChange={updateParams} value={value} fields={fields} />
      </ModalLayout>
   );
});

BaseHostParamsModal.displayName = 'BaseHostParamsModal';
