import React, { useCallback, useMemo } from 'react';

import { CreateScenarioModal } from '../../../rich_shared';
import { IHostActionProps } from '../models';

export const CreateScenarioHostModal: React.FC<IHostActionProps> = React.memo(({ onRun, onCancel, context }) => {
   const initialValue = useMemo(
      () => ({
         hosts: new Set(context.map(item => item.name)),
      }),
      [context],
   );

   const handleOk = useCallback(() => onRun(null, []), [onRun]);

   const handleCancel = useCallback(() => onCancel(null), [onCancel]);

   return <CreateScenarioModal initialValue={initialValue} ok={handleOk} cancel={handleCancel} />;
});

CreateScenarioHostModal.displayName = 'CreateScenarioHostModal';
