import { FormLayout, IFormField, Loader } from '@yandex-infracloud-ui/libs-next';
import { ModalLayout } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { ReactNode, SyntheticEvent } from 'react';

import { IHostActionProps } from '../models';

import styles from './HostActionLayout.module.css';
import { SelectedHosts } from './SelectedHosts';

interface IProps extends IHostActionProps {
   cancelLabel?: string;
   fields: IFormField<any>[];
   isLoading?: boolean;
   runLabel?: string;
   title: string;
   subtitle: ReactNode;
   value: object;

   onChange(e: SyntheticEvent, value: object): void;

   onRun(e: SyntheticEvent): void;
}

export function HostActionLayout({
   cancelLabel = 'Cancel',
   context,
   fields,
   isLoading = false,
   onCancel,
   onChange,
   onRun,
   runLabel = 'Run',
   title,
   subtitle,
   value,
}: IProps) {
   return (
      <>
         <Loader cls={styles.loader} visible={isLoading} />

         <ModalLayout
            title={title}
            subtitle={subtitle}
            okLabel={runLabel}
            cancelLabel={cancelLabel}
            onOk={onRun}
            onDismiss={onCancel}
         >
            <SelectedHosts cls={styles.selected} hosts={context} />

            <FormLayout context={context} fields={fields} value={value} onChange={onChange} />
         </ModalLayout>
      </>
   );
}
