import * as React from 'react';
import { SyntheticEvent, useCallback, useState } from 'react';
import { DevJson } from '../../../shared';

import { HostActionMeta, IHostActionProps } from '../models';
import { HostActionLayout } from './HostActionLayout';

export const HostActionModal = React.memo(({ meta: metaRaw, onRun, onCancel, context }: IHostActionProps) => {
   const meta = metaRaw as HostActionMeta<any>;

   // hooks
   const [params, setParams] = useState(meta.initialValue);

   // handlers
   const updateParams = useCallback((e: SyntheticEvent | null, v: any) => setParams(meta.transform(v)), [meta]);

   const run = useCallback(
      (e: SyntheticEvent) =>
         onRun(
            e,
            context.map(host => meta.do(host, params, context)),
         ),
      [context, meta, onRun, params],
   );

   // render
   return (
      <>
         <HostActionLayout
            meta={meta}
            title={meta.getTitle(context)}
            subtitle={meta.getSubtitle()}
            runLabel={meta.getLabelFor('run')}
            cancelLabel={meta.getLabelFor('cancel')}
            onRun={run}
            onCancel={onCancel}
            fields={meta.fields}
            context={context}
            value={params}
            onChange={updateParams}
         />
         <DevJson>{meta.clean(params, context)}</DevJson>
      </>
   );
});

HostActionModal.displayName = 'HostActionModal';
