import { classNames, formatNumber, plural } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';

import { IHost } from '../../../models';

import styles from './SelectedHosts.module.css';

interface IProps {
   cls: string;
   hosts: IHost[];
}

export const SelectedHosts = ({ cls = '', hosts }: IProps) => {
   const title = plural(hosts.length, 'Selected host:', `Selected ${formatNumber(hosts.length)} hosts:`);

   return (
      <div className={classNames(styles.selectedHosts, cls)}>
         <div className={styles.title}>{title}</div>

         <div className={styles.hosts}>{hosts.map(h => h.name || `inv#${h.inv}`).join('\n')}</div>
      </div>
   );
};
