import { action } from '@storybook/addon-actions';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { VLANEditableList } from './VLANEditableList';

storiesOf('actions|host_actions/VLANEditableList', module)
   .add('Empty', () => (
      <VLANEditableList
         items={new Set()}
         onItemsChange={action('onItemsChange')}
         value={undefined}
         onChange={action('onChange')}
         canSelect={true}
      />
   ))
   .add('Can select', () => (
      <VLANEditableList
         items={new Set([233, 555, 334, 700, 1900])}
         onItemsChange={action('onItemsChange')}
         value={555}
         onChange={action('onChange')}
         canSelect={true}
      />
   ))
   .add('Can not select', () => (
      <VLANEditableList
         items={new Set([233, 555, 334, 700, 1900])}
         onItemsChange={action('onItemsChange')}
         canSelect={false}
      />
   ));
