import { classNames, toggleSetItem } from '@yandex-infracloud-ui/libs';
import { Button, Icon } from 'lego-on-react';
import { default as React, SyntheticEvent } from 'react';

import deleteSvg from './icons/delete.svg';
import styles from './VLANEditableList.module.css';

interface IProps {
   canSelect: boolean;
   items: Set<number>;
   value?: number;

   onChange?(e: SyntheticEvent, value: number): void;

   onItemsChange(e: SyntheticEvent, items: Set<number>): void;
}

export function VLANEditableList(props: IProps) {
   const select = (item: number) => (e: SyntheticEvent) => {
      if (props.canSelect && props.onChange) {
         props.onChange(e, item);
      }
   };

   const remove = (item: number) => (e: SyntheticEvent) => {
      props.onItemsChange(e, toggleSetItem(props.items, item));
   };

   return (
      <div
         className={classNames(styles.vlanTable, {
            [styles.canSelect]: props.canSelect,
         })}
      >
         {Array.from(props.items).map(item => (
            <div key={item} className={styles.item}>
               <span
                  className={classNames(styles.vlan, {
                     [styles.selected]: props.canSelect && props.value === item,
                  })}
                  onClick={select(item)}
               >
                  {item}
               </span>

               <Button
                  theme={'clear'}
                  size={'s'}
                  cls={styles.delete}
                  onClick={remove(item)}
                  icon={<Icon url={deleteSvg} />}
               />
            </div>
         ))}
      </div>
   );
}
