import { storiesOf } from '@storybook/react';
import { json } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import * as React from 'react';
import { useState } from 'react';

import { IHostActionParams } from '../../models';
import { modalsSupportDecorator } from '../../stories';

import { hostActionService } from './host_action_service';

const AskBaseParamsStory = () => {
   // hooks
   const [params, setParams] = useState<IHostActionParams | null>(null);

   // handlers
   const ask = () => {
      hostActionService.askBaseParams('only for story').subscribe(setParams, e => console.warn('Close reason', e));
   };

   // render
   return (
      <>
         <Button theme={'normal'} size={'s'} text={'Ask'} onClick={ask} />
         <pre>{json(params)}</pre>
      </>
   );
};

storiesOf('actions|host_actions/host_action_service', module)
   .addDecorator(modalsSupportDecorator)
   .add('askBaseParams', () => <AskBaseParamsStory />);
