import { BaseActionService, IResultWithAction, modalService } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';

import { IHost, IHostActionParams } from '../../models';

import { BaseHostParamsModal } from './components/BaseHostParamsModal';
import { HostAction, HostSubject } from './models';

class HostActionService extends BaseActionService {
   public do(action: HostAction, context: IHost[]): Observable<IResultWithAction<IHost[]>> {
      return this.doAction(HostSubject, action, context);
   }

   public askBaseParams(title: string): Observable<IHostActionParams> {
      return modalService.open(BaseHostParamsModal, { title });
   }
}

export const hostActionService = new HostActionService();
