import { clearParams, IActionWithModal, IBaseActionProps, IFormField, plural } from '@yandex-infracloud-ui/libs-next';
import { ComponentType, ReactNode } from 'react';
import { Observable } from 'rxjs';

import { IHost, IHostActionParams } from '../../models';
import { hostApi } from '../../services';
import { HostActionModal } from './components/HostActionModal';

export const HostSubject = 'host';

export interface IHostActionProps extends IBaseActionProps<IHost[]> {}

/**
 * Значения этого перечисления используются для подстановки в URL, а не просто взяты наобум
 */
export enum HostAction {
   CancelTask = 'cancel-task',
   ChangeMaintenance = 'change-maintenance',
   CheckDNS = 'check-dns',
   DeployConfig = 'deploy_config',
   EditExtraVlans = 'edit-extra-vlans',
   ForceStatus = 'force-status',
   FqdnDeinvalidation = 'fqdn-deinvalidation',
   PowerOff = 'power-off',
   PowerOn = 'power-on',
   Prepare = 'prepare',
   Profile = 'profile',
   Reboot = 'reboot',
   Redeploy = 'redeploy',
   Remove = 'remove',
   SetAssigned = 'set-assigned',
   SetMaintenance = 'set-maintenance',
   SwitchProject = 'switch-project',
   SwitchVlans = 'switch-vlans',
   CreateScenario = 'create-scenario',
   Release = 'release-host',
   CreateTicket = 'create-ticket',
}

interface ILabels {
   cancel: string;
   run: string;
}

interface IHostActionMetaArgs<T> {
   action: HostAction;
   fields: IFormField<T>[];
   initialValue: T;
   labels?: Partial<ILabels>;
   name: string;
   titles: [string, string];
}

export class HostActionMeta<T extends IHostActionParams> implements IActionWithModal<IHostActionParams> {
   public readonly action: HostAction;

   public readonly component: ComponentType<any> = HostActionModal;

   public readonly fields: IFormField<T>[] = [];

   public readonly important: boolean = true;

   public readonly initialValue: T;

   public readonly name: string;

   public readonly titles: [string, string];

   private readonly labels?: { run?: string; cancel?: string };

   constructor(config: IHostActionMetaArgs<T>) {
      this.action = config.action;
      this.fields = config.fields;
      this.initialValue = config.initialValue;
      this.labels = config.labels;
      this.name = config.name;
      this.titles = config.titles;
   }

   public getLabelFor(key: keyof ILabels): string | undefined {
      return this.labels && this.labels[key] ? this.labels[key] : undefined;
   }

   public transform(params: T): T {
      return params;
   }

   public clean(params: T, context: IHost[]): Partial<T> {
      return clearParams(this.fields, params, context);
   }

   public do(host: IHost, params: T, context: IHost[]): Observable<any> {
      return hostApi.doSimpleAction(host.uuid, this.action, this.clean(params, context));
   }

   public getTitle(context: IHost[]): string {
      return plural(context.length, ...this.titles);
   }

   public getSubtitle(): ReactNode {
      return null;
   }
}
