import { IResult } from '@yandex-infracloud-ui/libs-next';
import { toasts } from '@yandex-infracloud-ui/libs';
import * as React from 'react';

import { IMaintenancePlot } from '../../models';
import { RowButtons } from '../../shared';
import { PlotAction } from './models';
import { maintenancePlotActionService } from './plot_action_service';

import { DeleteIcon } from 'design/icons';

interface IProps {
   cls?: string;
   context: IMaintenancePlot;

   onActionFinished(action: PlotAction, result: IResult[]): void;
}

export const PlotActionButtons = React.memo(({ cls, context, onActionFinished }: IProps) => {
   const buttons = [
      {
         handler: () => {
            maintenancePlotActionService
               .do(PlotAction.Remove, context)
               .subscribe(
                  resp => onActionFinished(PlotAction.Remove, resp.results),
                  toasts.handleApiError('Remove maintenance plot'),
               );
         },
         icon: <DeleteIcon />,
         name: 'Remove',
      },
   ];

   return <RowButtons cls={cls} buttons={buttons} />;
});

PlotActionButtons.displayName = 'PlotActionButtons';
