import { autobind, FormFieldType, FormLayout, IFormField } from '@yandex-infracloud-ui/libs-next';

import { Button } from '@yandex-data-ui/common';

import { object } from 'prop-types';
import * as React from 'react';
import { SyntheticEvent } from 'react';
import { Observable } from 'rxjs';

import { IPlotActionParams } from '../../../models';
import { maintenancePlotsApi } from '../../../services';
import { IPlotActionProps } from '../models';

import styles from './RemovePlotAction.module.css';

import { CloseIcon } from 'design/icons';

interface IState {
   params: IPlotActionParams;
}

export class RemovePlotAction extends React.PureComponent<IPlotActionProps, IState> {
   public static defaultProps = {};

   public static propTypes = {
      context: object.isRequired as any,
   };

   public state: IState = {
      params: {
         reason: '',
      },
   };

   private _formFields: IFormField<IPlotActionParams>[] = [
      {
         label: 'Reason',
         name: 'reason',
         placeholder: 'Enter reason...',
         type: FormFieldType.Text,
      },
   ];

   public render() {
      return (
         <div className={styles.removePlotModal}>
            <div className={styles.header}>
               <Button view={'clear'} size={'m'} className={styles.close} onClick={this._close}>
                  <CloseIcon size={'lg'} />
               </Button>

               <h2>Remove plot {this.props.context!.meta_info!.name}</h2>
            </div>

            <div className={styles.body}>
               <FormLayout fields={this._formFields} value={this.state.params} onChange={this._onChange} />
            </div>

            <div className={styles.footer}>
               <Button view={'clear'} size={'m'} onClick={this._close}>
                  Cancel
               </Button>
               <Button view={'action'} size={'m'} onClick={this._onRun}>
                  Confirm
               </Button>
            </div>
         </div>
      );
   }

   @autobind
   private _close(e: SyntheticEvent) {
      this.props.onCancel(e);
   }

   private _doAction(): Observable<void> {
      return maintenancePlotsApi.remove(this.props.context!.id, this.state.params);
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private _onChange(e: SyntheticEvent, params: IPlotActionParams) {
      this.setState({ params });
   }

   @autobind
   private _onRun(e: SyntheticEvent): void {
      this.props.onRun(e, [this._doAction()]);
   }
}
