import { BaseActionService, IResultWithAction } from '@yandex-infracloud-ui/libs-next';
import { Observable } from 'rxjs';
import { IMaintenancePlot } from '../../models';

import { PlotAction, MaintenancePlotSubject } from './models';

class MaintenancePlotActionService extends BaseActionService {
   public do(action: PlotAction, context: IMaintenancePlot): Observable<IResultWithAction<IMaintenancePlot>> {
      return this.doAction(MaintenancePlotSubject, action, context);
   }
}

export const maintenancePlotActionService = new MaintenancePlotActionService();
