import React, { memo, FC } from 'react';
import { FontAwesomeIcon, FontAwesomeIconProps } from '@fortawesome/react-fontawesome';

import { faBell, faCircle, faPause, faCube } from '@fortawesome/free-solid-svg-icons';
import { faTimes, faPencil } from '@fortawesome/pro-light-svg-icons';
import {
   faTrashAlt,
   faPlusCircle,
   faPowerOff,
   faBars,
   faExclamationTriangle,
   faSearch,
   faArrowToLeft,
   faArrowToRight,
   faCopy,
   faBellSlash,
   faSave,
   faCog,
   faCheck,
   faFlagCheckered,
   faClock,
   faFolderOpen,
   faRedo,
} from '@fortawesome/pro-regular-svg-icons';
import { faMoon, faSun, faSortDown, faSortUp, faStopwatch } from '@fortawesome/pro-solid-svg-icons';

export interface IIconProps extends Omit<FontAwesomeIconProps, 'icon'> {}

export const AddIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faPlusCircle} {...props} />);
export const ArrowLeftIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faArrowToLeft} {...props} />);
export const ArrowRightIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faArrowToRight} {...props} />);
export const BarsIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faBars} {...props} />);
export const BellIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faBell} {...props} />);
export const CircleIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faCircle} {...props} />);
export const CloseIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faTimes} {...props} />);
export const CopyIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faCopy} {...props} />);
export const CoqIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faCog} {...props} />);
export const CubeIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faCube} {...props} />);
export const DeleteIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faTrashAlt} {...props} />);
export const DoneIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faCheck} {...props} />);
export const FinishedIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faFlagCheckered} {...props} />);
export const FolderOpenIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faFolderOpen} {...props} />);
export const MoonIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faMoon} {...props} />);
export const PauseIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faPause} {...props} />);
export const PencilIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faPencil} {...props} />);
export const PowerOffIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faPowerOff} {...props} />);
export const RedoIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faRedo} {...props} />);
export const SaveIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faSave} {...props} />);
export const SearchIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faSearch} {...props} />);
export const SlashBellIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faBellSlash} {...props} />);
export const SortDownIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faSortDown} {...props} />);
export const SortUpIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faSortUp} {...props} />);
export const StartedIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faStopwatch} {...props} />);
export const SunIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faSun} {...props} />);
export const WaitingIcon: FC<IIconProps> = memo(props => <FontAwesomeIcon icon={faClock} {...props} />);
export const WarnIcon: FC<IIconProps> = memo(props => (
   <FontAwesomeIcon icon={faExclamationTriangle} size={'sm'} {...props} />
));
