// tslint:disable-next-line:no-reference
import '@yandex-data-ui/common/styles/styles.scss';
import '@yandex-data-ui/common/styles/themes.scss';
/// <reference path='./typings.d.ts' />
import '@yandex-infracloud-ui/libs-next/dist/index.css';
import '@yandex-infracloud-ui/libs/dist/index.css';
import './design/common.css';
import { globalHotKeys, initMetrika } from '@yandex-infracloud-ui/libs';
import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { BrowserRouter, Route } from 'react-router-dom';

import { App } from './_layout/App';
import { ErrorBoundary } from './_layout/ErrorBoundary';
import { navigateHook, redirects, RootScreen } from './routes';
import { auth, config, sentry } from './services';
import { errorBooster } from './services/error-booster';
import * as serviceWorker from './serviceWorker';
import { store } from './state';
// import './performance';

console.log('Config is', config);

sentry.init(); // Sentry важно инициировать ДО приложения
errorBooster.init();

ReactDOM.render(
   <ErrorBoundary>
      <BrowserRouter>
         <Provider store={store}>
            <App>
               <RootScreen />
               <Route path={'/'} render={redirects} />
               <Route path={'/'} render={navigateHook} />
            </App>
         </Provider>
      </BrowserRouter>
   </ErrorBoundary>,
   document.getElementById('root'),
);

globalHotKeys.init();
auth.init();

if (config.metrikaId) {
   initMetrika(config.metrikaId);
}

// const startTime = Date.now();

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: http://bit.ly/CRA-PWA
// serviceWorker.register({
//    onUpdate: () => {
//       const durationInSeconds = (Date.now() - startTime) / 1000;
//
//       // Если прошло менее 5 секунд после загрузки страницы и уже есть обновление - обновляем без запроса
//       if (durationInSeconds < 10 || window.confirm('New version is available. Do update?')) {
//          window.location.reload();
//       }
//    },
// });
//
serviceWorker.unregister();
