import { AutomationLimit } from './AutomationLimit';

describe('AutomationLimit', () => {
   it('create valid', () => {
      expect(() => new AutomationLimit(10, '1d')).not.toThrow();
   });

   it('create invalid', () => {
      expect(() => new AutomationLimit(-1, '1m')).toThrow('Limit must be not negative integer');
      expect(() => new AutomationLimit(3, '-1w')).toThrow('Period value must be positive integer');
      expect(() => new AutomationLimit(3, '0w')).toThrow('Period value must be positive integer');
      expect(() => new AutomationLimit(2, '1y')).toThrow('Period must be in $number(s|m|h|d|w) format');
   });

   it('should toString()', () => {
      expect(new AutomationLimit(1, '1h').toString()).toBe('1 in a hour');
      expect(new AutomationLimit(1, '2h').toString()).toBe('1 in 2 hours');
      expect(new AutomationLimit(2, '1h').toString()).toBe('2 in a hour');
      expect(new AutomationLimit(15, '17h').toString()).toBe('15 in 17 hours');
   });
});
