import { NullableDate } from '@yandex-infracloud-ui/libs-next';

export const allLogItemFields = [
   'automation_plot',
   'error',
   'host_inv',
   'host_name',
   'id',
   'issuer',
   'payload',
   'project',
   'reason',
   'scenario_id',
   'status',
   'status_time',
   'time',
   'type',
];

export const shortLogItemFields = [
   'automation_plot',
   'error',
   'host_inv',
   'host_name',
   'id',
   'issuer',
   'payload',
   'project',
   'reason',
   'scenario_id',
   'status',
   'status_time',
   'time',
   'type',
];

export interface ILogItem {
   automation_plot?: string;
   error?: string;
   host_inv: number;
   host_name: string;
   id: string;
   issuer: string;
   payload: any;
   project: string;
   reason?: string;
   scenario_id?: number;
   status: string;
   status_time: Date | number;
   /**
    * Это поле не из API, а рассчитывается сразу после получения списка
    */
   subItems?: this[];
   time: Date | number;
   type: string;
}

export interface ILogRequest {
   cursor?: Date;
   end_time?: NullableDate;
   fields: string[];
   host_inv?: Set<number>;
   host_name?: Set<string>;
   host_uuid?: Set<string>;
   issuer: Set<string>;
   limit: number;
   preorder?: Set<string>;
   project?: Set<string>;
   scenario_id?: Set<string>;
   start_time?: NullableDate;
   status: Set<string>;
   type: Set<string>;
}
