type ProjectRole = 'owner' | 'user' | 'superuser';

export interface IUserInfo {
   admin: boolean;
   automation_plots: [];
   groups: [];
   login: string;
   projects: string[];
   project_roles: { [key: string]: ProjectRole[] };
}

export class UserModel {
   // eslint-disable-next-line no-useless-constructor
   constructor(
      public readonly id: string,
      public readonly login: string,
      public readonly name: string,
      public readonly isAdmin: boolean,
      public readonly source: 'cookie' | 'api',
      public readonly groups: string[],
      public readonly projects: string[],
      public readonly projectRoles: { [key: string]: ProjectRole[] },
      public readonly automationPlots: string[],
   ) {}
}
