import { DAY_IN_SEC, MINUTE_IN_SEC } from '@yandex-infracloud-ui/libs';
import { date, number, object, Schema, string } from 'yup';

// TODO добавить в библиотеку
export interface INewApiError {
   errors: string[];
   message: string;
   result: 'FAIL';
}

export interface IApiError {
   errorMessage: string;
}

export interface IListResult<T> {
   result: T[];

   /**
    * Сколько вообще существует элементов в этом списке (без учёта пагинации)
    */
   total?: number;

   /**
    * Значение cursor в запросе следующей страницы
    */
   next_cursor?: number;
}

export function parseApiError(error: string | IApiError | INewApiError): string {
   const apiError = error as IApiError & { message: string };

   let errorMessage = '';

   if (typeof error === 'string') {
      errorMessage = error as string;
   } else if (error && 'errorMessage' in apiError) {
      errorMessage = apiError.errorMessage;
   } else if (error && 'message' in apiError) {
      errorMessage = apiError.message;
   } else {
      errorMessage = error.toString();
   }

   return errorMessage;
}

export enum TimeoutMode {
   Date = 'date',
   Timer = 'timer',
}

export interface TimeoutValue {
   date: Date | null;
   mode: TimeoutMode;
   timer: number;
}

export const timeoutValueSchema = object<TimeoutValue>({
   date: date().label('Deactivation date'),
   mode: string().oneOf([TimeoutMode.Date, TimeoutMode.Timer]).required() as Schema<TimeoutMode>,
   timer: number()
      .label('Deactivation date')
      .required()
      .moreThan(10 * MINUTE_IN_SEC)
      .lessThan(7 * DAY_IN_SEC),
});
