import { ISuggestBaseEntity } from '@yandex-infracloud-ui/libs';
import { ScenarioWorkStatus } from 'rich_shared/scenario_list/models';
import { Provisioner } from '../enums';
import { VlanSchema } from './projects';

export interface IBoxesEine {
   deploy_host?: string;
   eine_host?: string;
   ipmiproxy_host?: string;
}

export interface IBoxes {
   dns: {
      [k: string]: {
         console_url: string;
         endpoint: string;
         key_id: string;
         service_account_id: string;
         type: string;
      };
   };
   eine: {
      [k: string]: IBoxesEine;
   };
}

export interface ILocation {
   name: string;
   nodes?: ILocation[];
   path: string;
}

export interface IConstantGroups {
   [key: string]: string[];
}

export interface IConstantEnumRecord {
   description: string;
   name: string;
}

export interface IConstants {
   allowed_default_profiles: string[];
   audit_log_statuses: string[];
   audit_log_types: string[];
   existing_tiers: number[];
   operation_log_types: string[];
   cms_api_versions: string[];
   deploy_config_policies: IConstantEnumRecord[];
   health_check_groups: IConstantGroups;
   health_check_types: string[];
   health_statuses: string[];
   host_limits: string[];
   host_states: string[];
   host_statuses: string[];
   host_types: string[];
   known_queues_for_tickets: string[];
   mtn_ip_methods: string[];
   project_automation_limits: string[];
   provisioners: Provisioner[];
   restrictions: string[];
   restrictions_dependency_mapping: IConstantGroups;
   scenario_types: string[];
   scenario_work_statuses: ScenarioWorkStatus[];
   vlan_schemes: VlanSchema[];
}

export interface IConfig {
   ctype: string;
}

export interface IDeployConfigs {
   eine: string[];
   lui: string[];
}

export interface IGlobalSettings {
   /**
    * Disable DNS automation
    */
   disable_dns_automation?: boolean;

   /**
    * Disable automated healing
    */
   disable_healing_automation?: boolean;
}

export interface IBotProject {
   en_description: string;
   parent_project_id: number | null;
   planner_id: number;
   project_id: number;
   ru_description: string;
   subprojects: IBotProject[];
   isOld?: boolean;
   searchIndex?: string;
}

export interface IHbfProject extends ISuggestBaseEntity {
   id: string;
   name: string;
   title: string;
}
