import { ScenarioType } from 'rich_shared/scenario_list/models';

export const allMaintenancePlotFields = ['id', 'meta_info', 'common_settings', 'scenarios_settings', 'gc_enabled'];

export interface IMaintenanceScenarioSetting {
   id?: number;
   scenario_type: ScenarioType | undefined;
   settings: {
      request_cms_x_seconds_before_maintenance_start_time?: number | null;
      enable_redeploy_after_change_of_mac_address?: boolean;
      enable_manual_approval_after_hosts_power_off?: boolean;
      ignore_cms_on_host_operations?: boolean;
      get_approvers_to_ticket_if_hosts_not_in_maintenance_by_start_time?: boolean;
      get_approvers_to_ticket_if_hosts_not_in_maintenance_by_x_seconds?: number | null;
      start_power_off_x_seconds_before_maintenance_start_time?: number | null;
      approval_sla?: number | null;
      use_yp_sla?: boolean;
   };
}

export interface IMaintenancePlot {
   _canEdit?: boolean;
   _isNewPlot?: boolean;
   id: string;
   gc_enabled?: boolean;
   meta_info: {
      abc_service_slug: string;
      name: string;
   };
   common_settings: {
      common_scenario_settings?: {
         dont_allow_start_scenario_if_total_number_of_active_hosts_more_than: number | null;
         total_number_of_active_hosts: number | null;
      };
      maintenance_approvers: {
         logins?: string[];
         abc_roles_codes?: string[];
         abc_role_scope_slugs?: string[];
         abc_duty_schedule_slugs?: string[];
      };
   };
   scenarios_settings: IMaintenanceScenarioSetting[];
}
