import { NullableDate } from '@yandex-infracloud-ui/libs-next';

export const operationLogItemFields = [
   'audit_log_id',
   'id',
   'inv',
   'name',
   'host_inv',
   'host_name',
   'params',
   'time',
   'type',
];

export interface IOperationLogItem {
   error?: string;
   host_inv: number;
   host_name: string;
   id: string;
   project: string;
   reason?: string;
   status_time: Date | number;
   time: Date | number;
   type: string;
   audit_log_id: string;
   params: any;
   scenario_id?: number;

   // calculated property
   isSubItem?: boolean;
}

export interface IOperationLogRequest {
   id?: Set<string>;
   cursor?: Date;
   end_time?: NullableDate;
   fields: string[];
   host_inv?: Set<number>;
   host_name?: Set<string>;
   host_uuid?: Set<string>;
   limit: number;
   project?: Set<string>;
   start_time?: NullableDate;
   type: Set<string>;
   audit_log_id?: Set<string>;
}
