import {
   HostStatus,
   Labels,
   ScenarioScriptArgs,
   ScenarioStatus,
   ScenarioWorkStatus,
   ScenarioType,
   ScheduleType,
} from '../../rich_shared/scenario_list/models';

export interface IScenarioFilters {
   issuer?: string;
   query: string;
   workStatus?: Set<string>;
   type?: Set<string>;
}

export interface IScenarioListRequest {
   fields: string[];
   issuer: string;
   limit: number;
   name: Set<string>;
   offset: number;
   scenario_id: Set<number>;
   scenario_type: Set<string>;
   schedule_type: Set<ScheduleType>;
   work_status: Set<string>;
}

export interface IScenarioHost {
   inv: number;
   status: HostStatus;
   timestamp?: number | Date;
}

interface ScenarioExceptionInfo {
   error_message: string;
   exc_id: string;
   host_inv: number;
   host_name: string;
   host_uuid: string;
   stage_action: string;
   stage_name: string;
   stage_uid: string;
   timestamp: number;
}

export interface ScenarioError {
   exc_info?: ScenarioExceptionInfo;
   id: string;
   is_visible: boolean;
   repeats: number;
   retry_period: number;
   type: string;
}

export interface ScenarioErrors {
   [errorId: string]: ScenarioError;
}

export interface IScenario {
   action_time: number;
   creation_time?: number;
   // TODO параметр используется только для JSON отображения. написать интерфейс
   data_storage?: any;
   message?: string;
   errors?: ScenarioErrors;
   hosts?: IScenarioHost[];
   issuer: string;
   labels?: any;
   name: string;
   scenario_id: number;
   scenario_type?: ScenarioType;
   schedule_type?: ScheduleType;
   script_args?: ScenarioScriptArgs;
   status: ScenarioStatus;
   workStatus: ScenarioWorkStatus;
   switch?: string;
   ticket_key: string;
}

export interface ScenarioNoc {
   action_time: number;
   hosts?: IScenarioHost[];
   id: number;
   issuer: string;
   name: string;
   status: ScenarioStatus;
   workStatus: ScenarioWorkStatus;
   switch: string;
   ticket_key: string;
}

export interface ScenarioParams {
   autostart: boolean;
   hosts?: Set<string>;
   labels?: Labels;
   name: string;
   scenario_type: ScenarioType;
   reason?: string;
   ticket_key?: string;
   script_args: {
      target_project_id?: string;
      delete?: boolean;
      abc_service_id?: number;
      schedule_type?: 'all';
      rack?: string;
      idle_time?: number;
      workdays_only?: boolean;
      maintenance_start_time?: number;
      maintenance_end_time?: number;
      switch?: string;
   };
}

interface IScenarioActionParams {
   reason?: string;
}

// tslint:disable-next-line:no-empty-interface
export interface IScenarioPauseParams extends IScenarioActionParams {}

// tslint:disable-next-line:no-empty-interface
export interface IScenarioSkipParams extends IScenarioActionParams {}

// tslint:disable-next-line:no-empty-interface
export interface IScenarioCancelParams extends IScenarioActionParams {}

// tslint:disable-next-line:no-empty-interface
export interface IScenarioFinishParams extends IScenarioActionParams {}

// tslint:disable-next-line:no-empty-interface
export interface IScenarioStartParams extends IScenarioActionParams {}
