export interface IStaffApiRequestParams {
   _fields?: string;
   _limit?: number; // 50
   _one?: 1;
   _page?: number; // 1
   _pretty?: 1;
   _query?: string;
   _sort?: string;

   [field: string]: any;
}

export interface IStaffApiResponse<T> {
   limit: number;
   links: any;
   page: number;
   pages: number;
   result: T[];
   total: number;
}

export interface ILocalizableString {
   en: string;
   ru: string;
}

export interface IStaffPersonResponse {
   emails: { address: string }[];
   login: string;
   name: {
      last: ILocalizableString;
      first: ILocalizableString;
   };
}

export interface IStaffPerson {
   email: string;
   login: string;
   name: string;
}
