export enum HostHealthStatus {
   /**
    * Host marked failed because check failed
    */
   Failed = 'failed',

   /**
    * Check has invalid metadata
    */
   Invalid = 'invalid',

   /**
    * Host marked suspected because check failed for host but it's to early to mark it failed.
    */
   Suspected = 'suspected',

   /**
    * Check is staled
    */
   Staled = 'staled',

   /**
    * Check is missing
    */
   Missing = 'missing',

   /**
    * Check is missing, Wall-E has not received check data
    */
   Void = 'void',

   /**
    * Check passed
    */
   Passed = 'passed',

   /**
    * Check data is not fresh enough, need to wait for check status update
    */
   Unsure = 'unsure',
}

export enum ScenarioStageStatus {
   Queue = 'queue',
   Finished = 'finished',
   Processing = 'processing',
}

export type MacAddress = string;

export enum HostLogType {
   Deploy = 'deploy',
   Profile = 'profile',
   Coroner = 'coroner',
}

export enum Provisioner {
   LUI = 'lui',
   EINE = 'eine', // eine устарел
}

export enum ProjectType {
   SERVER = 'server',
   VM = 'vm',
   MAC = 'mac',
   SHADOW = 'shadow-server',
}

export const DefaultProvisioner = Provisioner.LUI;

export enum DeployNetwork {
   Project = 'project',
   Service = 'service',
}

export const DefaultDeployNetwork = DeployNetwork.Project;

export const DefaultDeployConfigPolicy = 'passthrough';

export enum OperationState {
   Operation = 'operation', // default
   Decommissioned = 'decommissioned',
}

export const DefaultOperationState = OperationState.Operation;

export enum CmsTaskAction {
   Profile = 'profile',
   Reboot = 'reboot',
   TemporaryUnreachable = 'temporary-unreachable',
}

export const DefaultCmsTaskAction = CmsTaskAction.Profile;

export enum OwnershipValue {
   All = 'all',
   My = 'my',
}

export const DefaultOwnership = OwnershipValue.All;
