import { setAsArray } from '@yandex-infracloud-ui/libs';
import { Schema, string, TestMessageParams } from 'yup';

import { DEPLOY_TAG_REGEXP, PROJECT_TAG_REGEXP } from './regexps';

export const projectTagSchema: Schema<Set<string>> = setAsArray().of(
   string()
      .min(2)
      .max(32)
      .matches(
         PROJECT_TAG_REGEXP,
         (params: Partial<TestMessageParams>) =>
            `"${params.originalValue}" is invalid tag. Tag must contain only [a-zA-Z0-9_.:-] symbols.`,
      ),
) as any;

export const deployTagSchema: Schema<Set<string>> = setAsArray()
   .max(20)
   .of(
      string()
         .min(2)
         .max(32)
         .matches(
            DEPLOY_TAG_REGEXP,
            (params: Partial<TestMessageParams>) =>
               `"${params.originalValue}" is invalid tag. Tag must contain only [a-zA-Z0-9_=:-] symbols.`,
         ),
   ) as any;
