import { text } from '@storybook/addon-knobs';
import { DevJson } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';
import { host } from 'storybook-host';

import { IStoryDefaults } from '../../stories/typings';

import { abcBotApi } from './abcBotApi';
import { AbcBotInput } from './AbcBotInput';
import { IABCService } from './models';

export const RegularStory = () => {
   // hooks
   const [value, setValue] = useState<IABCService | null>(null);

   // handlers
   const select = (e: SyntheticEvent | null, v: IABCService) => setValue(v);

   // render
   return (
      <>
         <AbcBotInput initialQuery={text('initialQuery', 'infra')} onSelect={select} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const ResolveAbcStory = () => {
   // hooks
   const [value, setValue] = useState<any | null>(null);

   // handlers
   const run = () => {
      abcBotApi.getABCServiceByBotProject(100000601).subscribe(setValue);
   };

   // render
   return (
      <>
         <Button theme={'normal'} size={'s'} onClick={run} text={'Resolve'} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};
export default {
   decorators: [host({ align: 'left' })],
   title: 'rich_shared|AbcBotInput',
} as IStoryDefaults;
