import { Suggest } from '@yandex-data-ui/common';
import { ISuggestBaseEntity } from '@yandex-infracloud-ui/libs-next';
import React, { useCallback, useState, useEffect } from 'react';
import { SyntheticEvent } from 'react';

import { SuggestSelectItem } from 'shared';
import { strategy } from './strategy';

interface IProps {
   autofocus?: boolean;
   clearOnSelect?: boolean;
   cls?: string;
   disabled?: boolean;
   initialQuery?: string;
   name?: string;

   onSelect(e: SyntheticEvent | null, item: ISuggestBaseEntity | null): void;

   onBlur?(e: React.FocusEvent<HTMLInputElement>): void;
}

export const AbcBotInput: React.FC<IProps> = props => {
   const { onSelect, initialQuery, disabled } = props;
   const [query, setQuery] = useState(initialQuery);

   const handleClick = useCallback(
      (v: ISuggestBaseEntity) => {
         setQuery(() => v.title);
         onSelect(null, v || null);
      },
      [onSelect],
   );

   const handleGetItems = useCallback(async (q): Promise<ISuggestBaseEntity[] | any> => {
      if (!q) return [];

      return strategy
         .load(q)
         .toPromise()
         .then((resp: ISuggestBaseEntity[]) => resp.slice(0, 10));
   }, []);

   useEffect(() => {
      setQuery(() => initialQuery);
   }, [initialQuery]);

   return (
      <Suggest
         getItems={handleGetItems}
         text={query}
         getItemsOnMount={true}
         onUpdate={setQuery}
         onItemClick={handleClick}
         onInputEnterKeyDown={setQuery}
         applicableInputValue={true}
         disabled={disabled}
         placeholder={'ABC service slug'}
         renderItem={item => <SuggestSelectItem title={item.title} desc={`: ID (${item.id})`} />}
         debounce={500}
         syncPopupOnResize={false}
      />
   );
};

AbcBotInput.displayName = 'AbcBotInput';
