import { ISuggestBaseEntity, ISuggestStrategy } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';

import { abcBotApi } from './abcBotApi';
import { AbcServiceItem } from './AbcServiceItem';
import { IABCService } from './models';

class AbcServiceStrategy implements ISuggestStrategy {
   public load(query: string): Observable<ISuggestBaseEntity[]> {
      return abcBotApi.findABCService(query).pipe(map(items => items.map(i => this._convertToSuggestItem(i))));
   }

   public renderItem(entity: IABCService): JSX.Element {
      return <AbcServiceItem item={entity} />;
   }

   public getQueryFromEntity(entity: IABCService): string {
      return entity.slug;
   }

   public getPlaceholder(): string {
      return 'ABC service slug';
   }

   private _convertToSuggestItem(entity: IABCService): ISuggestBaseEntity {
      return {
         ...entity,

         id: entity.id,
         title: entity.slug,
      };
   }
}

export const strategy: ISuggestStrategy = new AbcServiceStrategy();
