import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { Route } from 'react-router';

import { routerDecorator, reduxStoryDecorator } from '../../stories';

import { AuditLog } from './AuditLog';
import { ILogFilters, LogLayout } from './models';

interface IProps {
   forceFilters?: Partial<ILogFilters>;
   layout: LogLayout;
}

function AuditLogStory({ layout, forceFilters }: IProps) {
   return <Route render={routeProps => <AuditLog forceFilters={forceFilters} layout={layout} {...routeProps} />} />;
}

storiesOf('rich_shared|AuditLog', module)
   .addDecorator(routerDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('layout=all', () => <AuditLogStory layout={'all'} />)
   .add('layout=host', () => (
      <AuditLogStory
         layout={'host'}
         forceFilters={{
            fqdn: 'myt1-2725.search.yandex.net 434055',
         }}
      />
   ));
