import { storiesOf } from '@storybook/react';
import { toggleSetItem } from '@yandex-infracloud-ui/libs-next';
import * as React from 'react';
import { useState } from 'react';

import { ILogItem } from '../../../models';
import { routerDecorator, reduxStoryDecorator } from '../../../stories';
import { _groupLogItems } from '../AuditLog.state';

import { LogList } from './LogList';

const LogListStory = () => {
   // hooks
   const [expanded, setExpanded] = useState(new Set<string>());

   // handlers
   const expand = (id: string) => setExpanded(toggleSetItem(expanded, id));

   // noinspection SpellCheckingInspection
   const items: ILogItem[] = _groupLogItems([
      {
         host_inv: 101731207,
         host_name: 'vla2-3440.search.yandex.net',
         id: '2f73baef67084ab3a7a7fd4203392799',
         issuer: 'wall-e',
         payload: { 'bla-bla': {} },
         project: 'rtc-yt-mtn',
         status: 'completed',
         status_time: new Date('2019-04-04T06:16:05.000Z'),
         time: new Date('2019-04-03T06:16:05.000Z'),
         type: 'active-mac-change-detected',
      },
      {
         host_inv: 101731207,
         host_name: 'vla2-3440.search.yandex.net',
         id: '7151dc4a324644e0b830462ee4646653',
         issuer: 'robot-walle@',
         payload: { 'bla-bla': {} },
         project: 'rtc-yt-mtn',
         reason: 'The host belongs to G@ALL_WALLE_TESTING_MACHINES . W@[rtc-yt-mtn search-yt-testing] tag.',
         status: 'completed',
         status_time: new Date('2019-04-04T01:16:05.000Z'),
         time: new Date('2019-04-03T07:16:05.000Z'),
         type: 'add-host',
      },
      {
         host_inv: 101731207,
         host_name: 'vla2-3440.search.yandex.net',
         id: '7151dc4a324644e0b830462ee4646652',
         issuer: 'robot-walle@',
         project: 'rtc-yt-mtn',
         reason: 'The host belongs to G@ALL_WALLE_TESTING_MACHINES . W@[rtc-yt-mtn search-yt-testing] tag.',
         status: 'completed',
         status_time: new Date('2019-04-04T01:16:05.000Z'),
         time: new Date('2019-04-03T08:16:05.000Z'),
         type: 'add-host',
      },
   ] as any[]) as ILogItem[];

   return <LogList expanded={expanded} expand={expand} items={items} isLoading={false} layout={'host'} />;
};

storiesOf('rich_shared|AuditLog', module)
   .addDecorator(routerDecorator)
   .addDecorator(reduxStoryDecorator)
   .add('LogList (grouped)', () => <LogListStory />);
