import { Loader } from '@yandex-infracloud-ui/libs-next';
import { array, bool, func, instanceOf } from 'prop-types';
import * as React from 'react';

import { ILogItem } from '../../../models';

import { LogLayout } from '../models';
import { LogItem } from './LogItem';
import styles from './LogList.module.css';

interface IProps {
   expanded: Set<string>;
   isLoading: boolean;
   items: ILogItem[];
   layout: LogLayout;

   expand(id: string): void;
}

export class LogList extends React.PureComponent<IProps> {
   public static defaultProps = {};

   public static propTypes = {
      expand: func.isRequired,
      expanded: instanceOf(Set).isRequired,
      isLoading: bool.isRequired,
      items: array.isRequired,
   };

   public render() {
      const isOneKindOfTarget = this.props.layout === 'host';

      return (
         <>
            <table className={styles.table}>
               <thead>
                  <tr>
                     {isOneKindOfTarget ? null : <th />}
                     <th>Target</th>
                     <th>Type</th>
                     <th>Status</th>
                     <th>Issuer</th>
                     <th>Date</th>
                     <th>Information</th>
                  </tr>
               </thead>
               <tbody>
                  {this.props.items.map(li => (
                     <LogItem
                        key={li.id}
                        layout={this.props.layout}
                        value={li}
                        expanded={this.props.expanded}
                        expand={this.props.expand}
                     />
                  ))}
               </tbody>
            </table>

            <Loader cls={styles.loader} visible={this.props.isLoading} text={'Audit log loading'} />

            {this.props.items.length === 0 && !this.props.isLoading ? (
               <div className={styles.noData} data-e2e={'no-data'}>
                  No data
               </div>
            ) : null}
         </>
      );
   }
}
