import { autobind, formatDate, timeDistance } from '@yandex-infracloud-ui/libs';
import { Tooltip } from 'lego-on-react';
import { instanceOf } from 'prop-types';
import * as React from 'react';

import styles from './TimePeriod.module.css';

interface IProps {
   end: Date;
   start: Date;
}

interface IState {
   tooltip: boolean;
}

export class TimePeriod extends React.PureComponent<IProps, IState> {
   public static defaultProps = {};

   public static propTypes = {
      end: instanceOf(Date).isRequired,
      start: instanceOf(Date).isRequired,
   };

   public state: IState = {
      tooltip: false,
   };

   private _ref = React.createRef<HTMLDivElement>();

   public render() {
      return (
         <>
            <div
               className={styles.timePeriod}
               ref={this._ref}
               onMouseEnter={this._showTooltip}
               onMouseLeave={this._hideTooltip}
            >
               <time className={styles.start}>{formatDate(this.props.start as Date)}</time>

               <time className={styles.end}>End: {formatDate(this.props.end as Date)}</time>
            </div>
            <Tooltip
               theme={'white'}
               size={'s'}
               cls={styles.tooltip}
               anchor={this._ref.current}
               visible={this.state.tooltip}
               to={'bottom'}
            >
               {timeDistance(this.props.end, this.props.start)}
            </Tooltip>
         </>
      );
   }

   @autobind
   private _hideTooltip() {
      this.setState({ tooltip: false });
   }

   @autobind
   private _showTooltip() {
      this.setState({ tooltip: true });
   }
}
