import { dateToUrl, urlToDate } from './dateInUrl';

describe('AuditLog|dateInUrl', () => {
   describe('dateToUrl', () => {
      it('should works', () => {
         expect(dateToUrl(new Date('2018-11-13T00:55:34Z'))).toBe('2018-11-13_00-55-00Z');
      });
   });

   describe('urlToDate', () => {
      it('should works with datetime', () => {
         expect(urlToDate('2018-11-13_00-55-34Z')).toEqual(new Date('2018-11-13T00:55:34Z'));
      });

      it('should works with only date', () => {
         expect(urlToDate('2018-11-13')).toEqual(new Date('2018-11-13T00:00:00'));
      });

      it('should works with only date', () => {
         expect(urlToDate('2018-11-13', true)).toEqual(new Date('2018-11-13T23:59:59'));
      });
   });
});
