import { parseDate } from '@yandex-infracloud-ui/libs-next';
import { endOfDay, setMilliseconds, setSeconds } from 'date-fns';

const urlDateRegexp = /^\d{4}-\d{2}-\d{2}_\d{2}-\d{2}-\d{2}Z$/;

export function dateToUrl(date: Date): string {
   return setSeconds(date, 0)
      .toJSON()
      .replace('T', '_')
      .replace(/:/g, '-')
      .replace(/\.\d{3}Z$/, 'Z');
}

export function urlToDate(dateInUrl: string, fixEndOfDay = false): Date {
   if (urlDateRegexp.test(dateInUrl)) {
      const [year, month, day, hours, minutes, seconds] = dateInUrl.replace(/Z$/, '').split(/[_-]/);

      return new Date(`${year}-${month}-${day}T${hours}:${minutes}:${seconds}Z`);
   }

   let result = parseDate(dateInUrl);
   if (fixEndOfDay) {
      result = setMilliseconds(endOfDay(result), 0);
   }

   return result;
}
