import { getDefaultLogFilters, ILogFilters, logFiltersToUrlParams, urlParamsToLogFilters } from './models';

describe('AuditLog models', () => {
   it('should work with dates', () => {
      const filters: ILogFilters = {
         ...getDefaultLogFilters(),
         from: new Date('2019-04-01 0:00:00'),
      };

      const urlParams = logFiltersToUrlParams(filters as ILogFilters);

      expect(urlParams.from).toBe('2019-03-31_21-00-00Z');

      expect(urlParamsToLogFilters(urlParams).from).toEqual(new Date('2019-04-01 0:00:00'));
   });
});
