import * as React from 'react';
import { IBotProject } from '../../models';
import styles from './BotProjectItem.module.css';

interface IProps {
   item: IBotProject;
}

export const BotProjectItem = React.memo((props: IProps) => (
   <div className={styles.root}>
      {props.item.en_description} <span className={styles.id}>(ID:&nbsp;{props.item.planner_id})</span>
   </div>
));

BotProjectItem.displayName = 'BotProjectItem';
