import { BaseApi, IApiError } from '@yandex-infracloud-ui/libs-next';
import { Observable } from 'rxjs';
import { map } from 'rxjs/operators';
import { IBotProject } from '../../models';

import { dictApi, sentry } from '../../services';

class BotProjectApi extends BaseApi {
   public getSuggestions(query: string, showAll?: boolean): Observable<IBotProject[]> {
      return dictApi
         .getBotProjects()
         .pipe(
            map(resp =>
               resp.filter(item => (showAll || !item.isOld) && item.searchIndex?.includes(query.toLowerCase())),
            ),
         )
         .pipe(map(resp => resp.slice(0, 10)));
   }

   public getABCServiceByBotProject(query: number): Observable<IBotProject | null> {
      return dictApi.getBotProjects().pipe(map(resp => resp.find(item => item.project_id === query) ?? null));
   }

   protected getCSRF(): string {
      return ''; // нерелевантно для данного API
   }

   protected handleError(resp: Response, error: IApiError): void {
      sentry.sendApiError(resp, error);
   }
}

export const botProjectApi = new BotProjectApi('/external_api/abc');
